# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Dict, List, Optional, TYPE_CHECKING, Union

from .. import _serialization

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models


class Resource(_serialization.Model):
    """Common fields that are returned in the response for all Azure Resource Manager resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None


class TrackedResource(Resource):
    """The resource model definition for an Azure Resource Manager tracked top level resource which has 'tags' and a 'location'.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
    }

    def __init__(self, *, location: str, tags: Optional[Dict[str, str]] = None, **kwargs):
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.location = location


class AttestationProvider(TrackedResource):
    """Attestation service response message.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar system_data: The system metadata relating to this resource.
    :vartype system_data: ~azure.mgmt.attestation.models.SystemData
    :ivar trust_model: Trust model for the attestation provider.
    :vartype trust_model: str
    :ivar status: Status of attestation service. Known values are: "Ready", "NotReady", and
     "Error".
    :vartype status: str or ~azure.mgmt.attestation.models.AttestationServiceStatus
    :ivar attest_uri: Gets the uri of attestation service.
    :vartype attest_uri: str
    :ivar private_endpoint_connections: List of private endpoint connections associated with the
     attestation provider.
    :vartype private_endpoint_connections:
     list[~azure.mgmt.attestation.models.PrivateEndpointConnection]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
        "system_data": {"readonly": True},
        "private_endpoint_connections": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "trust_model": {"key": "properties.trustModel", "type": "str"},
        "status": {"key": "properties.status", "type": "str"},
        "attest_uri": {"key": "properties.attestUri", "type": "str"},
        "private_endpoint_connections": {
            "key": "properties.privateEndpointConnections",
            "type": "[PrivateEndpointConnection]",
        },
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        trust_model: Optional[str] = None,
        status: Optional[Union[str, "_models.AttestationServiceStatus"]] = None,
        attest_uri: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword trust_model: Trust model for the attestation provider.
        :paramtype trust_model: str
        :keyword status: Status of attestation service. Known values are: "Ready", "NotReady", and
         "Error".
        :paramtype status: str or ~azure.mgmt.attestation.models.AttestationServiceStatus
        :keyword attest_uri: Gets the uri of attestation service.
        :paramtype attest_uri: str
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.system_data = None
        self.trust_model = trust_model
        self.status = status
        self.attest_uri = attest_uri
        self.private_endpoint_connections = None


class AttestationProviderListResult(_serialization.Model):
    """Attestation Providers List.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar system_data: The system metadata relating to this resource.
    :vartype system_data: ~azure.mgmt.attestation.models.SystemData
    :ivar value: Attestation Provider array.
    :vartype value: list[~azure.mgmt.attestation.models.AttestationProvider]
    """

    _validation = {
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "system_data": {"key": "systemData", "type": "SystemData"},
        "value": {"key": "value", "type": "[AttestationProvider]"},
    }

    def __init__(self, *, value: Optional[List["_models.AttestationProvider"]] = None, **kwargs):
        """
        :keyword value: Attestation Provider array.
        :paramtype value: list[~azure.mgmt.attestation.models.AttestationProvider]
        """
        super().__init__(**kwargs)
        self.system_data = None
        self.value = value


class AttestationServiceCreationParams(_serialization.Model):
    """Parameters for creating an attestation provider.

    All required parameters must be populated in order to send to Azure.

    :ivar location: The supported Azure location where the attestation provider should be created.
     Required.
    :vartype location: str
    :ivar tags: The tags that will be assigned to the attestation provider.
    :vartype tags: dict[str, str]
    :ivar properties: Properties of the attestation provider. Required.
    :vartype properties: ~azure.mgmt.attestation.models.AttestationServiceCreationSpecificParams
    """

    _validation = {
        "location": {"required": True},
        "properties": {"required": True},
    }

    _attribute_map = {
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "properties": {"key": "properties", "type": "AttestationServiceCreationSpecificParams"},
    }

    def __init__(
        self,
        *,
        location: str,
        properties: "_models.AttestationServiceCreationSpecificParams",
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        """
        :keyword location: The supported Azure location where the attestation provider should be
         created. Required.
        :paramtype location: str
        :keyword tags: The tags that will be assigned to the attestation provider.
        :paramtype tags: dict[str, str]
        :keyword properties: Properties of the attestation provider. Required.
        :paramtype properties: ~azure.mgmt.attestation.models.AttestationServiceCreationSpecificParams
        """
        super().__init__(**kwargs)
        self.location = location
        self.tags = tags
        self.properties = properties


class AttestationServiceCreationSpecificParams(_serialization.Model):
    """Client supplied parameters used to create a new attestation provider.

    :ivar policy_signing_certificates: JSON Web Key Set defining a set of X.509 Certificates that
     will represent the parent certificate for the signing certificate used for policy operations.
    :vartype policy_signing_certificates: ~azure.mgmt.attestation.models.JSONWebKeySet
    """

    _attribute_map = {
        "policy_signing_certificates": {"key": "policySigningCertificates", "type": "JSONWebKeySet"},
    }

    def __init__(self, *, policy_signing_certificates: Optional["_models.JSONWebKeySet"] = None, **kwargs):
        """
        :keyword policy_signing_certificates: JSON Web Key Set defining a set of X.509 Certificates
         that will represent the parent certificate for the signing certificate used for policy
         operations.
        :paramtype policy_signing_certificates: ~azure.mgmt.attestation.models.JSONWebKeySet
        """
        super().__init__(**kwargs)
        self.policy_signing_certificates = policy_signing_certificates


class AttestationServicePatchParams(_serialization.Model):
    """Parameters for patching an attestation provider.

    :ivar tags: The tags that will be assigned to the attestation provider.
    :vartype tags: dict[str, str]
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(self, *, tags: Optional[Dict[str, str]] = None, **kwargs):
        """
        :keyword tags: The tags that will be assigned to the attestation provider.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.tags = tags


class CloudErrorBody(_serialization.Model):
    """An error response from Attestation.

    :ivar code: An identifier for the error. Codes are invariant and are intended to be consumed
     programmatically.
    :vartype code: str
    :ivar message: A message describing the error, intended to be suitable for displaying in a user
     interface.
    :vartype message: str
    """

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
    }

    def __init__(self, *, code: Optional[str] = None, message: Optional[str] = None, **kwargs):
        """
        :keyword code: An identifier for the error. Codes are invariant and are intended to be consumed
         programmatically.
        :paramtype code: str
        :keyword message: A message describing the error, intended to be suitable for displaying in a
         user interface.
        :paramtype message: str
        """
        super().__init__(**kwargs)
        self.code = code
        self.message = message


class JSONWebKey(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """JSONWebKey.

    All required parameters must be populated in order to send to Azure.

    :ivar alg: The "alg" (algorithm) parameter identifies the algorithm intended for
     use with the key.  The values used should either be registered in the
     IANA "JSON Web Signature and Encryption Algorithms" registry
     established by [JWA] or be a value that contains a Collision-
     Resistant Name.
    :vartype alg: str
    :ivar crv: The "crv" (curve) parameter identifies the curve type.
    :vartype crv: str
    :ivar d: RSA private exponent or ECC private key.
    :vartype d: str
    :ivar dp: RSA Private Key Parameter.
    :vartype dp: str
    :ivar dq: RSA Private Key Parameter.
    :vartype dq: str
    :ivar e: RSA public exponent, in Base64.
    :vartype e: str
    :ivar k: Symmetric key.
    :vartype k: str
    :ivar kid: The "kid" (key ID) parameter is used to match a specific key.  This
     is used, for instance, to choose among a set of keys within a JWK Set
     during key rollover.  The structure of the "kid" value is
     unspecified.  When "kid" values are used within a JWK Set, different
     keys within the JWK Set SHOULD use distinct "kid" values.  (One
     example in which different keys might use the same "kid" value is if
     they have different "kty" (key type) values but are considered to be
     equivalent alternatives by the application using them.)  The "kid"
     value is a case-sensitive string.
    :vartype kid: str
    :ivar kty: The "kty" (key type) parameter identifies the cryptographic algorithm
     family used with the key, such as "RSA" or "EC". "kty" values should
     either be registered in the IANA "JSON Web Key Types" registry
     established by [JWA] or be a value that contains a Collision-
     Resistant Name.  The "kty" value is a case-sensitive string. Required.
    :vartype kty: str
    :ivar n: RSA modulus, in Base64.
    :vartype n: str
    :ivar p: RSA secret prime.
    :vartype p: str
    :ivar q: RSA secret prime, with p < q.
    :vartype q: str
    :ivar qi: RSA Private Key Parameter.
    :vartype qi: str
    :ivar use: Use ("public key use") identifies the intended use of
     the public key. The "use" parameter is employed to indicate whether
     a public key is used for encrypting data or verifying the signature
     on data. Values are commonly "sig" (signature) or "enc" (encryption).
    :vartype use: str
    :ivar x: X coordinate for the Elliptic Curve point.
    :vartype x: str
    :ivar x5_c: The "x5c" (X.509 certificate chain) parameter contains a chain of one
     or more PKIX certificates [RFC5280].  The certificate chain is
     represented as a JSON array of certificate value strings.  Each
     string in the array is a base64-encoded (Section 4 of [RFC4648] --
     not base64url-encoded) DER [ITU.X690.1994] PKIX certificate value.
     The PKIX certificate containing the key value MUST be the first
     certificate.
    :vartype x5_c: list[str]
    :ivar y: Y coordinate for the Elliptic Curve point.
    :vartype y: str
    """

    _validation = {
        "kty": {"required": True},
    }

    _attribute_map = {
        "alg": {"key": "alg", "type": "str"},
        "crv": {"key": "crv", "type": "str"},
        "d": {"key": "d", "type": "str"},
        "dp": {"key": "dp", "type": "str"},
        "dq": {"key": "dq", "type": "str"},
        "e": {"key": "e", "type": "str"},
        "k": {"key": "k", "type": "str"},
        "kid": {"key": "kid", "type": "str"},
        "kty": {"key": "kty", "type": "str"},
        "n": {"key": "n", "type": "str"},
        "p": {"key": "p", "type": "str"},
        "q": {"key": "q", "type": "str"},
        "qi": {"key": "qi", "type": "str"},
        "use": {"key": "use", "type": "str"},
        "x": {"key": "x", "type": "str"},
        "x5_c": {"key": "x5c", "type": "[str]"},
        "y": {"key": "y", "type": "str"},
    }

    def __init__(
        self,
        *,
        kty: str,
        alg: Optional[str] = None,
        crv: Optional[str] = None,
        d: Optional[str] = None,
        dp: Optional[str] = None,
        dq: Optional[str] = None,
        e: Optional[str] = None,
        k: Optional[str] = None,
        kid: Optional[str] = None,
        n: Optional[str] = None,
        p: Optional[str] = None,
        q: Optional[str] = None,
        qi: Optional[str] = None,
        use: Optional[str] = None,
        x: Optional[str] = None,
        x5_c: Optional[List[str]] = None,
        y: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword alg: The "alg" (algorithm) parameter identifies the algorithm intended for
         use with the key.  The values used should either be registered in the
         IANA "JSON Web Signature and Encryption Algorithms" registry
         established by [JWA] or be a value that contains a Collision-
         Resistant Name.
        :paramtype alg: str
        :keyword crv: The "crv" (curve) parameter identifies the curve type.
        :paramtype crv: str
        :keyword d: RSA private exponent or ECC private key.
        :paramtype d: str
        :keyword dp: RSA Private Key Parameter.
        :paramtype dp: str
        :keyword dq: RSA Private Key Parameter.
        :paramtype dq: str
        :keyword e: RSA public exponent, in Base64.
        :paramtype e: str
        :keyword k: Symmetric key.
        :paramtype k: str
        :keyword kid: The "kid" (key ID) parameter is used to match a specific key.  This
         is used, for instance, to choose among a set of keys within a JWK Set
         during key rollover.  The structure of the "kid" value is
         unspecified.  When "kid" values are used within a JWK Set, different
         keys within the JWK Set SHOULD use distinct "kid" values.  (One
         example in which different keys might use the same "kid" value is if
         they have different "kty" (key type) values but are considered to be
         equivalent alternatives by the application using them.)  The "kid"
         value is a case-sensitive string.
        :paramtype kid: str
        :keyword kty: The "kty" (key type) parameter identifies the cryptographic algorithm
         family used with the key, such as "RSA" or "EC". "kty" values should
         either be registered in the IANA "JSON Web Key Types" registry
         established by [JWA] or be a value that contains a Collision-
         Resistant Name.  The "kty" value is a case-sensitive string. Required.
        :paramtype kty: str
        :keyword n: RSA modulus, in Base64.
        :paramtype n: str
        :keyword p: RSA secret prime.
        :paramtype p: str
        :keyword q: RSA secret prime, with p < q.
        :paramtype q: str
        :keyword qi: RSA Private Key Parameter.
        :paramtype qi: str
        :keyword use: Use ("public key use") identifies the intended use of
         the public key. The "use" parameter is employed to indicate whether
         a public key is used for encrypting data or verifying the signature
         on data. Values are commonly "sig" (signature) or "enc" (encryption).
        :paramtype use: str
        :keyword x: X coordinate for the Elliptic Curve point.
        :paramtype x: str
        :keyword x5_c: The "x5c" (X.509 certificate chain) parameter contains a chain of one
         or more PKIX certificates [RFC5280].  The certificate chain is
         represented as a JSON array of certificate value strings.  Each
         string in the array is a base64-encoded (Section 4 of [RFC4648] --
         not base64url-encoded) DER [ITU.X690.1994] PKIX certificate value.
         The PKIX certificate containing the key value MUST be the first
         certificate.
        :paramtype x5_c: list[str]
        :keyword y: Y coordinate for the Elliptic Curve point.
        :paramtype y: str
        """
        super().__init__(**kwargs)
        self.alg = alg
        self.crv = crv
        self.d = d
        self.dp = dp
        self.dq = dq
        self.e = e
        self.k = k
        self.kid = kid
        self.kty = kty
        self.n = n
        self.p = p
        self.q = q
        self.qi = qi
        self.use = use
        self.x = x
        self.x5_c = x5_c
        self.y = y


class JSONWebKeySet(_serialization.Model):
    """JSONWebKeySet.

    :ivar keys: The value of the "keys" parameter is an array of JWK values.  By
     default, the order of the JWK values within the array does not imply
     an order of preference among them, although applications of JWK Sets
     can choose to assign a meaning to the order for their purposes, if
     desired.
    :vartype keys: list[~azure.mgmt.attestation.models.JSONWebKey]
    """

    _attribute_map = {
        "keys": {"key": "keys", "type": "[JSONWebKey]"},
    }

    def __init__(self, *, keys: Optional[List["_models.JSONWebKey"]] = None, **kwargs):
        """
        :keyword keys: The value of the "keys" parameter is an array of JWK values.  By
         default, the order of the JWK values within the array does not imply
         an order of preference among them, although applications of JWK Sets
         can choose to assign a meaning to the order for their purposes, if
         desired.
        :paramtype keys: list[~azure.mgmt.attestation.models.JSONWebKey]
        """
        super().__init__(**kwargs)
        self.keys = keys


class OperationList(_serialization.Model):
    """List of supported operations.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar system_data: The system metadata relating to this resource.
    :vartype system_data: ~azure.mgmt.attestation.models.SystemData
    :ivar value: List of supported operations.
    :vartype value: list[~azure.mgmt.attestation.models.OperationsDefinition]
    """

    _validation = {
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "system_data": {"key": "systemData", "type": "SystemData"},
        "value": {"key": "value", "type": "[OperationsDefinition]"},
    }

    def __init__(self, *, value: Optional[List["_models.OperationsDefinition"]] = None, **kwargs):
        """
        :keyword value: List of supported operations.
        :paramtype value: list[~azure.mgmt.attestation.models.OperationsDefinition]
        """
        super().__init__(**kwargs)
        self.system_data = None
        self.value = value


class OperationsDefinition(_serialization.Model):
    """Definition object with the name and properties of an operation.

    :ivar name: Name of the operation.
    :vartype name: str
    :ivar display: Display object with properties of the operation.
    :vartype display: ~azure.mgmt.attestation.models.OperationsDisplayDefinition
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "display": {"key": "display", "type": "OperationsDisplayDefinition"},
    }

    def __init__(
        self, *, name: Optional[str] = None, display: Optional["_models.OperationsDisplayDefinition"] = None, **kwargs
    ):
        """
        :keyword name: Name of the operation.
        :paramtype name: str
        :keyword display: Display object with properties of the operation.
        :paramtype display: ~azure.mgmt.attestation.models.OperationsDisplayDefinition
        """
        super().__init__(**kwargs)
        self.name = name
        self.display = display


class OperationsDisplayDefinition(_serialization.Model):
    """Display object with properties of the operation.

    :ivar provider: Resource provider of the operation.
    :vartype provider: str
    :ivar resource: Resource for the operation.
    :vartype resource: str
    :ivar operation: Short description of the operation.
    :vartype operation: str
    :ivar description: Description of the operation.
    :vartype description: str
    """

    _attribute_map = {
        "provider": {"key": "provider", "type": "str"},
        "resource": {"key": "resource", "type": "str"},
        "operation": {"key": "operation", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(
        self,
        *,
        provider: Optional[str] = None,
        resource: Optional[str] = None,
        operation: Optional[str] = None,
        description: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword provider: Resource provider of the operation.
        :paramtype provider: str
        :keyword resource: Resource for the operation.
        :paramtype resource: str
        :keyword operation: Short description of the operation.
        :paramtype operation: str
        :keyword description: Description of the operation.
        :paramtype description: str
        """
        super().__init__(**kwargs)
        self.provider = provider
        self.resource = resource
        self.operation = operation
        self.description = description


class PrivateEndpoint(_serialization.Model):
    """The Private Endpoint resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The ARM identifier for Private Endpoint.
    :vartype id: str
    """

    _validation = {
        "id": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.id = None


class PrivateEndpointConnection(Resource):
    """The Private Endpoint Connection resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar private_endpoint: The resource of private end point.
    :vartype private_endpoint: ~azure.mgmt.attestation.models.PrivateEndpoint
    :ivar private_link_service_connection_state: A collection of information about the state of the
     connection between service consumer and provider.
    :vartype private_link_service_connection_state:
     ~azure.mgmt.attestation.models.PrivateLinkServiceConnectionState
    :ivar provisioning_state: The provisioning state of the private endpoint connection resource.
     Known values are: "Succeeded", "Creating", "Deleting", and "Failed".
    :vartype provisioning_state: str or
     ~azure.mgmt.attestation.models.PrivateEndpointConnectionProvisioningState
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "private_endpoint": {"key": "properties.privateEndpoint", "type": "PrivateEndpoint"},
        "private_link_service_connection_state": {
            "key": "properties.privateLinkServiceConnectionState",
            "type": "PrivateLinkServiceConnectionState",
        },
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        private_endpoint: Optional["_models.PrivateEndpoint"] = None,
        private_link_service_connection_state: Optional["_models.PrivateLinkServiceConnectionState"] = None,
        **kwargs
    ):
        """
        :keyword private_endpoint: The resource of private end point.
        :paramtype private_endpoint: ~azure.mgmt.attestation.models.PrivateEndpoint
        :keyword private_link_service_connection_state: A collection of information about the state of
         the connection between service consumer and provider.
        :paramtype private_link_service_connection_state:
         ~azure.mgmt.attestation.models.PrivateLinkServiceConnectionState
        """
        super().__init__(**kwargs)
        self.private_endpoint = private_endpoint
        self.private_link_service_connection_state = private_link_service_connection_state
        self.provisioning_state = None


class PrivateEndpointConnectionListResult(_serialization.Model):
    """List of private endpoint connection associated with the specified storage account.

    :ivar value: Array of private endpoint connections.
    :vartype value: list[~azure.mgmt.attestation.models.PrivateEndpointConnection]
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[PrivateEndpointConnection]"},
    }

    def __init__(self, *, value: Optional[List["_models.PrivateEndpointConnection"]] = None, **kwargs):
        """
        :keyword value: Array of private endpoint connections.
        :paramtype value: list[~azure.mgmt.attestation.models.PrivateEndpointConnection]
        """
        super().__init__(**kwargs)
        self.value = value


class PrivateLinkServiceConnectionState(_serialization.Model):
    """A collection of information about the state of the connection between service consumer and provider.

    :ivar status: Indicates whether the connection has been Approved/Rejected/Removed by the owner
     of the service. Known values are: "Pending", "Approved", and "Rejected".
    :vartype status: str or ~azure.mgmt.attestation.models.PrivateEndpointServiceConnectionStatus
    :ivar description: The reason for approval/rejection of the connection.
    :vartype description: str
    :ivar actions_required: A message indicating if changes on the service provider require any
     updates on the consumer.
    :vartype actions_required: str
    """

    _attribute_map = {
        "status": {"key": "status", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "actions_required": {"key": "actionsRequired", "type": "str"},
    }

    def __init__(
        self,
        *,
        status: Optional[Union[str, "_models.PrivateEndpointServiceConnectionStatus"]] = None,
        description: Optional[str] = None,
        actions_required: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword status: Indicates whether the connection has been Approved/Rejected/Removed by the
         owner of the service. Known values are: "Pending", "Approved", and "Rejected".
        :paramtype status: str or ~azure.mgmt.attestation.models.PrivateEndpointServiceConnectionStatus
        :keyword description: The reason for approval/rejection of the connection.
        :paramtype description: str
        :keyword actions_required: A message indicating if changes on the service provider require any
         updates on the consumer.
        :paramtype actions_required: str
        """
        super().__init__(**kwargs)
        self.status = status
        self.description = description
        self.actions_required = actions_required


class SystemData(_serialization.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", and "Key".
    :vartype created_by_type: str or ~azure.mgmt.attestation.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", and "Key".
    :vartype last_modified_by_type: str or ~azure.mgmt.attestation.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        "created_by": {"key": "createdBy", "type": "str"},
        "created_by_type": {"key": "createdByType", "type": "str"},
        "created_at": {"key": "createdAt", "type": "iso-8601"},
        "last_modified_by": {"key": "lastModifiedBy", "type": "str"},
        "last_modified_by_type": {"key": "lastModifiedByType", "type": "str"},
        "last_modified_at": {"key": "lastModifiedAt", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        **kwargs
    ):
        """
        :keyword created_by: The identity that created the resource.
        :paramtype created_by: str
        :keyword created_by_type: The type of identity that created the resource. Known values are:
         "User", "Application", "ManagedIdentity", and "Key".
        :paramtype created_by_type: str or ~azure.mgmt.attestation.models.CreatedByType
        :keyword created_at: The timestamp of resource creation (UTC).
        :paramtype created_at: ~datetime.datetime
        :keyword last_modified_by: The identity that last modified the resource.
        :paramtype last_modified_by: str
        :keyword last_modified_by_type: The type of identity that last modified the resource. Known
         values are: "User", "Application", "ManagedIdentity", and "Key".
        :paramtype last_modified_by_type: str or ~azure.mgmt.attestation.models.CreatedByType
        :keyword last_modified_at: The timestamp of resource last modification (UTC).
        :paramtype last_modified_at: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.created_by = created_by
        self.created_by_type = created_by_type
        self.created_at = created_at
        self.last_modified_by = last_modified_by
        self.last_modified_by_type = last_modified_by_type
        self.last_modified_at = last_modified_at
