# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.service_client import SDKClient
from msrest import Serializer, Deserializer
from msrestazure import AzureConfiguration
from .version import VERSION
from .operations.operations import Operations
from .operations.devices_operations import DevicesOperations
from .operations.alerts_operations import AlertsOperations
from .operations.bandwidth_schedules_operations import BandwidthSchedulesOperations
from .operations.jobs_operations import JobsOperations
from .operations.operations_status_operations import OperationsStatusOperations
from .operations.orders_operations import OrdersOperations
from .operations.roles_operations import RolesOperations
from .operations.shares_operations import SharesOperations
from .operations.storage_account_credentials_operations import StorageAccountCredentialsOperations
from .operations.triggers_operations import TriggersOperations
from .operations.users_operations import UsersOperations
from . import models


class DataBoxEdgeManagementClientConfiguration(AzureConfiguration):
    """Configuration for DataBoxEdgeManagementClient
    Note that all parameters used to create this instance are saved as instance
    attributes.

    :param credentials: Credentials needed for the client to connect to Azure.
    :type credentials: :mod:`A msrestazure Credentials
     object<msrestazure.azure_active_directory>`
    :param subscription_id: The subscription ID.
    :type subscription_id: str
    :param str base_url: Service URL
    """

    def __init__(
            self, credentials, subscription_id, base_url=None):

        if credentials is None:
            raise ValueError("Parameter 'credentials' must not be None.")
        if subscription_id is None:
            raise ValueError("Parameter 'subscription_id' must not be None.")
        if not base_url:
            base_url = 'https://management.azure.com'

        super(DataBoxEdgeManagementClientConfiguration, self).__init__(base_url)

        self.add_user_agent('azure-mgmt-edgegateway/{}'.format(VERSION))
        self.add_user_agent('Azure-SDK-For-Python')

        self.credentials = credentials
        self.subscription_id = subscription_id


class DataBoxEdgeManagementClient(SDKClient):
    """DataBoxEdgeManagementClient

    :ivar config: Configuration for client.
    :vartype config: DataBoxEdgeManagementClientConfiguration

    :ivar operations: Operations operations
    :vartype operations: azure.mgmt.edgegateway.operations.Operations
    :ivar devices: Devices operations
    :vartype devices: azure.mgmt.edgegateway.operations.DevicesOperations
    :ivar alerts: Alerts operations
    :vartype alerts: azure.mgmt.edgegateway.operations.AlertsOperations
    :ivar bandwidth_schedules: BandwidthSchedules operations
    :vartype bandwidth_schedules: azure.mgmt.edgegateway.operations.BandwidthSchedulesOperations
    :ivar jobs: Jobs operations
    :vartype jobs: azure.mgmt.edgegateway.operations.JobsOperations
    :ivar operations_status: OperationsStatus operations
    :vartype operations_status: azure.mgmt.edgegateway.operations.OperationsStatusOperations
    :ivar orders: Orders operations
    :vartype orders: azure.mgmt.edgegateway.operations.OrdersOperations
    :ivar roles: Roles operations
    :vartype roles: azure.mgmt.edgegateway.operations.RolesOperations
    :ivar shares: Shares operations
    :vartype shares: azure.mgmt.edgegateway.operations.SharesOperations
    :ivar storage_account_credentials: StorageAccountCredentials operations
    :vartype storage_account_credentials: azure.mgmt.edgegateway.operations.StorageAccountCredentialsOperations
    :ivar triggers: Triggers operations
    :vartype triggers: azure.mgmt.edgegateway.operations.TriggersOperations
    :ivar users: Users operations
    :vartype users: azure.mgmt.edgegateway.operations.UsersOperations

    :param credentials: Credentials needed for the client to connect to Azure.
    :type credentials: :mod:`A msrestazure Credentials
     object<msrestazure.azure_active_directory>`
    :param subscription_id: The subscription ID.
    :type subscription_id: str
    :param str base_url: Service URL
    """

    def __init__(
            self, credentials, subscription_id, base_url=None):

        self.config = DataBoxEdgeManagementClientConfiguration(credentials, subscription_id, base_url)
        super(DataBoxEdgeManagementClient, self).__init__(self.config.credentials, self.config)

        client_models = {k: v for k, v in models.__dict__.items() if isinstance(v, type)}
        self.api_version = '2019-03-01'
        self._serialize = Serializer(client_models)
        self._deserialize = Deserializer(client_models)

        self.operations = Operations(
            self._client, self.config, self._serialize, self._deserialize)
        self.devices = DevicesOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.alerts = AlertsOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.bandwidth_schedules = BandwidthSchedulesOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.jobs = JobsOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.operations_status = OperationsStatusOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.orders = OrdersOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.roles = RolesOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.shares = SharesOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.storage_account_credentials = StorageAccountCredentialsOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.triggers = TriggersOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.users = UsersOperations(
            self._client, self.config, self._serialize, self._deserialize)
