// SPDX-FileCopyrightText: 2006-2025 Knut Reinert & Freie Universität Berlin
// SPDX-FileCopyrightText: 2016-2025 Knut Reinert & MPI für molekulare Genetik
// SPDX-License-Identifier: BSD-3-Clause

/*!\file
 * \author Rene Rahn <rene.rahn AT fu-berlin.de>
 * \brief Meta-header for the \link utility_type_list Utility / Type List submodule \endlink.
 */

/*!\defgroup utility_type_list Type List
 * \brief Provides seqan3::type_list and metaprogramming utilities for working on type lists.
 * \ingroup utility
 * \see utility
 *
 * \details
 *
 * All traits on type lists are defined in the header `<seqan3/utility/type_list/traits.hpp>`.
 *
 */

/*!\namespace seqan3::list_traits
 * \brief Namespace containing traits for working on seqan3::type_list.
 */

#pragma once

#include <seqan3/utility/type_list/traits.hpp>
#include <seqan3/utility/type_list/type_list.hpp>
