---
myst:
  html_meta:
    keywords: LaTeX, composition, texte, mots, espaces, approche, interlettre, interlettrage, 
              espacement des lettres, texte étiré
---

# Comment modifier l'espacement entre caractères ?

Une technique courante dans la publicité (et dans les textes dont le contenu n'a pas 
vraiment besoin d'être *lu*) consiste à modifier l'espace entre les lettres 
autrement dit l'interlettrage (ou *tracking* en anglais). 
En règle générale, c'est une très mauvaise idée : cela nuit à la lisibilité, 
en contradiction totale avec les principes de la composition. 
Toute police respectable que vous souhaitez utiliser devrait déjà avoir un interlettrage optimisé.

[Eric Gill](wpfr:Eric_Gill), grand concepteur de caractères, aurait dit : 
"celui qui modifie l'interlettrage d'un texte en minuscules pourrait voler des moutons". 
Si cette phrase est aussi attribuée à d'autres, 
il faut surtout noter que voler un mouton au 19{sup}`e` siècle était un crime passible 
de la peine capitale en Grande-Bretagne ! Vous voilà prévenus.

Comme la remarque le suggère indirectement, 
modifier l'interlettrage de mots en majuscules s'avère un crime bien moins terrible. 
Ceci sert aussi pour mettre en évidence un texte présenté avec des polices *[Fraktur](wpfr:Fraktur)* 
(ou similaires).


## Avec l'extension <ctanpkg:letterspacing>

Des commandes simples et utilisables, en principe, 
avec n'importe quel format de TeX peuvent être trouvées dans <ctanpkg:letterspacing>.


## Avec l'extension <ctanpkg:soul>

L'extension <ctanpkg:soul> permet de régler les espacements entre les caractères, dans les mots, 
et entre les mots eux-mêmes avec la commande `\so` (optimisée pour une utilisation
avec LaTeX mais utilisable avec Plain TeX). Les dimensions des espacements ajoutés entre les caractères, 
entre les mots et devant et derrière le texte interlettré peuvent être redéfinis à l'aide de la commande 
`\sodef⟨commande⟩{⟨fonte⟩}{⟨inter-lettres⟩}{⟨inter-mots⟩}{⟨encadrement⟩}` 
qui crée la commande `⟨commande⟩` affichant son argument dans la `⟨fonte⟩` indiquée avec :
- `⟨inter-lettres⟩` la taille des espaces entre les lettres de l'argument de votre commande ;
- `⟨inter-mots⟩` la taille des espaces classiques dans l'argument de votre commande ;
- `⟨encadrement⟩` la taille des espaces de part et d'autre de votre commande.

L'extension recommande d'utiliser des dimensions d'espaces définis en fonction 
de la fonte utilisée (telle `em`) pour que la modification soit un peu plus harmonieuse.

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{soul}

\begin{document}
\begin{center} 
\textbf{\so{L'INTERLETTRAGE}} 
\end{center} 

\sodef\test{\itshape}{0.8em}{0.2em}{2em} 

Une technique courante dans la publicité (et dans les textes dont le 
contenu n’a pas vraiment besoin d’être lu) consiste à modifier l’espace 
entre les lettres autrement dit \test{l’interlettrage} (ou \emph{tracking}
en anglais). 
\end{document}
```

L'extension permet, contrairement à <ctanpkg:letterspacing>, 
la césure du texte si les lettres sont espacées. 
L'avis de Gill sur une telle manipulation n'est, de façon fort regrettable, pas connu.


## Avec l'extension <ctanpkg:tracking>

L'extension <ctanpkg:tracking> permet de jouer sur les espacements dans les mots 
ou les phrases pour les ajuster dans une longueur spécifiée.
Elle propose trois commandes :
- `\track{⟨espace⟩}{⟨texte⟩}` qui ajoute une `⟨espace⟩` après chaque caractère du `⟨texte⟩` ;
- `\fittrack{⟨taille⟩}{⟨texte⟩}` qui ajuste la taille de son `⟨texte⟩` à la `⟨taille⟩` demandée 
  en manipulant l'interlettrage ; 
- `\ratiotrack{⟨ratio⟩}{⟨texte⟩}` qui procède comme la précédente mais en se basant sur un `⟨ratio⟩`. 

Cette extension, bien que disponible sur le CTAN, n'est pas installée par défaut. 
Ceci explique l'absence de résultat sur cette page de la FAQ.

```{noedit}
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{tracking}

\begin{document}
\begin{center} 
\textbf{\track{0.8em}{L'INTERLETTRAGE}} 
\end{center} 

Une \fittrack{2.5cm}{technique courante} dans la publicité (et dans les 
textes dont le contenu n’a pas vraiment besoin d’être lu) consiste à 
odifier l’espace entre les lettres autrement dit 
\ratiotrack{1.8}{l’interlettrage} (ou \emph{tracking} en anglais). 
\end{document}
```


## Avec l'extension <ctanpkg:microtype>

L'extension de référence dans ce domaine est sans doute <ctanpkg:microtype>. 
Elle utilise les capacités de microtypographie de pdfTeX avec une commande `\textls` : 
elle fonctionne selon les paramètres déclarés dans une commande `\SetTracking`. 
La fonction d'interlettrage de <ctanpkg:microtype> augmente l'espacement naturel de la police elle-même, 
plutôt que d'insérer un espace entre les caractères. 
Normalement, augmenter l'espace interlettre détruit les ligatures ; 
cependant, c'est *incorrect* pour certains styles de police (par exemple, *Fraktur*), 
et l'extension fournit ici un moyen pour protéger les ligatures dans un texte 
où les lettres ont été espacées.


:::{sources}
- [Changing the space between letters](faquk:FAQ-letterspace),
- [Approche (typographie)](wpfr:Approche_(typographie)).
:::