#!/usr/bin/env sh

# The first command argument $1 tells us which flavour to generate for
# the rest of the command line arguments.

what=$1
shift

if [ "x$*" = "x" ]; then
    none="(none)"
fi

case ${what} in
    header)
            cat << EOF
;; Copyright (C) 2019-2026 Free Software Foundation, Inc.
;;
;; This file is part of LIBF7, which is part of GCC.
;;
;; GCC is free software; you can redistribute it and/or modify it under
;; the terms of the GNU General Public License as published by the Free
;; Software Foundation; either version 3, or (at your option) any later
;; version.
;;
;; GCC is distributed in the hope that it will be useful, but WITHOUT ANY
;; WARRANTY; without even the implied warranty of MERCHANTABILITY or
;; FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
;; for more details.
;;
;; Under Section 7 of GPL version 3, you are granted additional
;; permissions described in the GCC Runtime Library Exception, version
;; 3.1, as published by the Free Software Foundation.
;;
;; You should have received a copy of the GNU General Public License and
;; a copy of the GCC Runtime Library Exception along with this program;
;; see the files COPYING3 and COPYING.RUNTIME respectively.  If not, see
;; <http://www.gnu.org/licenses/>.  */

;; Auto-generated file, do not change by hand.
;;
;; Wrappers for double and long double functions to use functions that
;; operate on f7_t, and get f7_t* and const f7_t*.
;;
;; Generated by: `basename $0`
;; Included by : libf7-asm.sx
EOF
        for n in $*; do
            echo ";; $n"
        done
        ;;

    xd_libgcc)
        cat << EOF

;; Functions that usually live in libgcc: __<name> for <name> in:
;; $*${none}
EOF
        for n in $*; do
            cat << EOF

;; type_t __${n} (double)  ; $n
#ifdef F7MOD_D_${n}_
_DEFUN __${n}
    .global F7_NAME($n)
    ldi     ZH,     hi8(gs(F7_NAME($n)))
    ldi     ZL,     lo8(gs(F7_NAME($n)))
    F7jmp   call_xd
_ENDF __${n}
#endif /* F7MOD_D_${n}_ */
EOF
        done
        ;;

    dx_libgcc)
        cat << EOF

;; Functions that usually live in libgcc: __<name> for <name> in:
;; $*${none}
EOF
        for n in $*; do
            cat << EOF

;; double __${n} (type_t)  ; $n
#ifdef F7MOD_D_${n}_
_DEFUN __${n}
    .global F7_NAME($n)
    ldi     ZH,     hi8(gs(F7_NAME($n)))
    ldi     ZL,     lo8(gs(F7_NAME($n)))
    F7jmp   call_dx
_ENDF __${n}
#endif /* F7MOD_D_${n}_ */
EOF
        done
        ;;

    ddd_libgcc)
        cat << EOF

;; Functions that usually live in libgcc: __<name>df3 for <name> in:
;; $*${none}
EOF
        for n in $*; do
            cat << EOF

;; double __${n}df3 (double, double)  ; $n
#ifdef F7MOD_D_${n}_
_DEFUN __${n}df3
    ALIAS __$n
    .global F7_NAME($n)
    ldi     ZH,     hi8(gs(F7_NAME($n)))
    ldi     ZL,     lo8(gs(F7_NAME($n)))
    F7jmp   call_ddd
_ENDF __${n}df3
#endif /* F7MOD_D_${n}_ */
EOF
        done
        ;;

    xdd_libgcc_cmp)
        cat << EOF

;; Functions that usually live in libgcc: __<name>df2 for <name> in:
;; $*${none}
EOF
        for n in $*; do
            cat << EOF

;; bool __${n}df2 (double, double)  ; $n
#ifdef F7MOD_D_${n}_
_DEFUN __${n}df2
    .global F7_NAME(${n}_impl)
    ldi     ZH,     hi8(gs(F7_NAME(${n}_impl)))
    ldi     ZL,     lo8(gs(F7_NAME(${n}_impl)))
    F7jmp   call_xdd
_ENDF __${n}df2
#endif /* F7MOD_D_${n}_ */
EOF
        done
        ;;

    dd_math)
        cat << EOF

;; Functions that usually live in libm:  Depending on [long] double layout,
;; define <name> and <name>l as weak alias(es) of __<name> for <name> in:
;; $*${none}
EOF
        for n in $*; do
            cat << EOF

;; double __${n} (double)
#ifdef F7MOD_D_${n}_
_DEFUN __${n}
    DALIAS $n
    LALIAS ${n}l
    .global F7_NAME($n)
    ldi     ZH,     hi8(gs(F7_NAME($n)))
    ldi     ZL,     lo8(gs(F7_NAME($n)))
    F7jmp   call_dd
_ENDF __${n}
#endif /* F7MOD_D_${n}_ */
EOF
        done
        ;;

    xd_math)
        cat << EOF

;; Functions that usually live in libm:  Depending on [long] double layout,
;; define <name> and <name>l as weak alias(es) of __<name> for <name> in:
;; $*${none}
EOF
        for n in $*; do
            cat << EOF

;; type_t __${n} (double)
#ifdef F7MOD_D_${n}_
_DEFUN __${n}
    DALIAS $n
    LALIAS ${n}l
    .global F7_NAME($n)
    ldi     ZH,     hi8(gs(F7_NAME($n)))
    ldi     ZL,     lo8(gs(F7_NAME($n)))
    F7jmp   call_xd
_ENDF __${n}
#endif /* F7MOD_D_${n}_ */
EOF
        done
        ;;

    ddd_math)
        cat << EOF

;; Functions that usually live in libm:  Depending on [long] double layout,
;; define <name> and <name>l as weak alias(es) of __<name> for <name> in:
;; $*${none}
EOF
        for n in $*; do
            cat << EOF

;; double __${n} (double, double)
#ifdef F7MOD_D_${n}_
_DEFUN __${n}
    DALIAS $n
    LALIAS ${n}l
    .global F7_NAME($n)
    ldi     ZH,     hi8(gs(F7_NAME($n)))
    ldi     ZL,     lo8(gs(F7_NAME($n)))
    F7jmp   call_ddd
_ENDF __${n}
#endif /* F7MOD_D_${n}_ */
EOF
        done
        ;;

    ddx_math)
        cat << EOF

;; Functions that usually live in libm:  Depending on [long] double layout,
;; define <name> and <name>l as weak alias(es) of __<name> for <name> in:
;; $*${none}
EOF
        for n in $*; do
            cat << EOF

;; double __${n} (double, word_t)
#ifdef F7MOD_D_${n}_
_DEFUN __${n}
    DALIAS $n
    LALIAS ${n}l
    .global F7_NAME($n)
    ldi     ZH,     hi8(gs(F7_NAME($n)))
    ldi     ZL,     lo8(gs(F7_NAME($n)))
    F7jmp   call_ddx
_ENDF __${n}
#endif /* F7MOD_D_${n}_ */
EOF
        done
        ;;

    *)
        exit 1
        ;;
esac
