/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/* 
 * lt-redundant-private.h
 * Copyright (C) 2011-2015 Akira TAGOH
 * 
 * Authors:
 *   Akira TAGOH  <akira@tagoh.org>
 * 
 * You may distribute under the terms of either the GNU
 * Lesser General Public License or the Mozilla Public
 * License, as specified in the README file.
 */
#ifndef __LT_REDUNDANT_PRIVATE_H__
#define __LT_REDUNDANT_PRIVATE_H__

#if !defined (__LANGTAG_PRIVATE)
#error "Unable to use the private header publicly"
#endif

#include "lt-macros.h"
#include "lt-redundant.h"

LT_BEGIN_DECLS

lt_redundant_t *lt_redundant_create           (void);
void            lt_redundant_set_tag          (lt_redundant_t *redundant,
                                               const char     *subtag);
void            lt_redundant_set_name         (lt_redundant_t *redundant,
                                               const char     *description);
void            lt_redundant_set_preferred_tag(lt_redundant_t *redundant,
                                               const char     *subtag);

LT_END_DECLS

#endif /* __LT_REDUNDANT_PRIVATE_H__ */
