/*
 * Copyright (C) 2023, KylinSoft Co., Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
**/
#ifndef CHANGEVALIDINTELDIALOG_H
#define CHANGEVALIDINTELDIALOG_H

#include <QDialog>

#include <QDate>

#include <QPainter>
#include <QPainterPath>


namespace Ui {
class ChangeValidIntelDialog;
}

class ChangeValidIntelDialog : public QDialog
{
    Q_OBJECT

public:
    explicit ChangeValidIntelDialog(QString userName, QWidget *parent = 0);
    ~ChangeValidIntelDialog();

    void setupConnect();

    void setUserName();
    void setUserLogo(QString face);
    void setUserType(QString atype);

    void _getCurrentPwdStatus();

    void setupCurrentValid();
    void setupComponent();

    void setupYearCombo();
    void setupMonthCombo();
    void setupDayCombo();

protected:
    void paintEvent(QPaintEvent *);

private:
    Ui::ChangeValidIntelDialog *ui;

private:
    QString _name;

    QDate lastChangeDate;

    int delayDays;
};

#endif // CHANGEVALIDINTELDIALOG_H
